/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.LinkedHashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.condition.common.SpellMasteryCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class AnimistsAwakeningEffect
extends OneShotEffect {
    AnimistsAwakeningEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Reveal the top X cards of your library. Put all land cards from among them onto the battlefield tapped and the rest on the bottom of your library in a random order.<br><i>Spell mastery</i> &mdash; If there are two or more instant and/or sorcery cards in your graveyard, untap those lands";
    }

    private AnimistsAwakeningEffect(AnimistsAwakeningEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        cards.addAllCards((Collection)controller.getLibrary().getTopCards(game, xValue));
        if (!cards.isEmpty()) {
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            LinkedHashSet<Card> toBattlefield = new LinkedHashSet<Card>();
            for (Card card : cards.getCards((FilterCard)new FilterLandCard(), source.getControllerId(), source, game)) {
                cards.remove(card);
                toBattlefield.add(card);
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, true, false, true, null);
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
            if (SpellMasteryCondition.instance.apply(game, source)) {
                for (Card card : toBattlefield) {
                    Permanent land = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                    if (land == null) continue;
                    land.untap(game);
                }
            }
        }
        return true;
    }

    public AnimistsAwakeningEffect copy() {
        return new AnimistsAwakeningEffect(this);
    }
}

