/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class AnointedPeacekeeperEffect
extends CostModificationEffectImpl {
    AnointedPeacekeeperEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, CostModificationType.INCREASE_COST);
        this.staticText = "Activated abilities of sources with the chosen name cost {2} more to activate unless they're mana abilities.";
    }

    private AnointedPeacekeeperEffect(AnointedPeacekeeperEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public AnointedPeacekeeperEffect copy() {
        return new AnointedPeacekeeperEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!abilityToModify.getAbilityType().isNonManaActivatedAbility()) {
            return false;
        }
        MageObject activatedSource = game.getObject(abilityToModify.getSourceId());
        if (activatedSource == null) {
            return false;
        }
        String chosenName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        return CardUtil.haveSameNames((MageObject)activatedSource, (String)chosenName, (Game)game);
    }
}

