/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileThenReturnTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class AnotherRoundEffect
extends OneShotEffect {
    public AnotherRoundEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile any number of creatures you control, then return them to the battlefield under their owner's control. Then repeat this process X more times.";
    }

    private AnotherRoundEffect(AnotherRoundEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(0, Integer.MAX_VALUE);
        target.withNotTarget(true);
        for (int i = 0; i <= xValue; ++i) {
            target.clearChosen();
            controller.chooseTarget(Outcome.Benefit, (Target)target, source, game);
            new ExileThenReturnTargetEffect(false, true).setTargetPointer((TargetPointer)new FixedTargets((Collection)target.getTargets().stream().map(id -> new MageObjectReference(id, game)).collect(Collectors.toList()))).apply(game, source);
            game.processAction();
        }
        return true;
    }

    public AnotherRoundEffect copy() {
        return new AnotherRoundEffect(this);
    }
}

