/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class AnowonTheRuinThiefEffect
extends OneShotEffect {
    AnowonTheRuinThiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player mills a card for each 1 damage dealt to them. If the player mills at least one creature card this way, you draw a card.";
    }

    private AnowonTheRuinThiefEffect(AnowonTheRuinThiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnowonTheRuinThiefEffect copy() {
        return new AnowonTheRuinThiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int damage = SavedDamageValue.MANY.calculate(game, source, (Effect)this);
        if (player.millCards(damage, source, game).count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) > 0 && (controller = game.getPlayer(source.getControllerId())) != null) {
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

