/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.a.AoTheDawnSkyTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class AoTheDawnSkyEffect
extends OneShotEffect {
    AoTheDawnSkyEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top seven cards of your library. Put any number of nonland permanent cards with total mana value 4 or less from among them onto the battlefield. Put the rest on the bottom of your library in a random order";
    }

    private AoTheDawnSkyEffect(AoTheDawnSkyEffect effect) {
        super((OneShotEffect)effect);
    }

    public AoTheDawnSkyEffect copy() {
        return new AoTheDawnSkyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 7));
        AoTheDawnSkyTarget target = new AoTheDawnSkyTarget();
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

