/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Optional;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseHalfLifeTargetEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ApheliaViperWhispererTriggeredAbility
extends DelayedTriggeredAbility
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    ApheliaViperWhispererTriggeredAbility() {
        super((Effect)new LoseHalfLifeTargetEffect(), Duration.EndOfTurn, false, false);
        this.setTriggerPhrase("Until end of turn, whenever one or more Gorgons and/or Snakes you control deal combat damage to a player, ");
    }

    private ApheliaViperWhispererTriggeredAbility(ApheliaViperWhispererTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public ApheliaViperWhispererTriggeredAbility copy() {
        return new ApheliaViperWhispererTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage()) return false;
        if (!Optional.ofNullable(event).map(GameEvent::getSourceId).map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).filter(permanent -> permanent.hasSubtype(SubType.GORGON, game) || permanent.hasSubtype(SubType.SNAKE, game)).map(Controllable::getControllerId).filter(arg_0 -> ((ApheliaViperWhispererTriggeredAbility)this).isControlledBy(arg_0)).isPresent()) return false;
        return true;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.getFilteredEvents((BatchEvent)((DamagedBatchForOnePlayerEvent)event), game).isEmpty()) {
            return false;
        }
        this.getAllEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
        return true;
    }
}

