/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.Choice;
import mage.choices.ChoiceColorOrArtifact;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class ApostlesBlessingEffect
extends OneShotEffect {
    ApostlesBlessingEffect() {
        super(Outcome.AddAbility);
        this.staticText = "Target artifact or creature you control gains protection from artifacts or from the color of your choice until end of turn";
    }

    private ApostlesBlessingEffect(ApostlesBlessingEffect effect) {
        super((OneShotEffect)effect);
    }

    public ApostlesBlessingEffect copy() {
        return new ApostlesBlessingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ChoiceColorOrArtifact choice;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.choose(this.outcome, (Choice)(choice = new ChoiceColorOrArtifact()), game)) {
            FilterCard protectionFilter = new FilterCard();
            if (choice.isArtifactSelected()) {
                protectionFilter.add((Predicate)CardType.ARTIFACT.getPredicate());
            } else {
                protectionFilter.add((Predicate)new ColorPredicate(choice.getColor()));
            }
            protectionFilter.setMessage(choice.getChoice());
            ProtectionAbility protectionAbility = new ProtectionAbility((Filter)protectionFilter);
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)protectionAbility, Duration.EndOfTurn);
            effect.setTargetPointer(this.getTargetPointer().copy());
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

