/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.filter.FilterSpell;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.common.SpellsCastWatcher;

class AquaticAlchemistTriggeredAbility
extends SpellCastControllerTriggeredAbility {
    private static final FilterInstantOrSorcerySpell filter = new FilterInstantOrSorcerySpell();

    AquaticAlchemistTriggeredAbility() {
        super((Effect)new BoostSourceEffect(2, 0, Duration.EndOfTurn), (FilterSpell)filter, false);
        this.setTriggerPhrase("whenever you cast your first instant or sorcery spell each turn, ");
    }

    private AquaticAlchemistTriggeredAbility(AquaticAlchemistTriggeredAbility ability) {
        super((SpellCastControllerTriggeredAbility)ability);
    }

    public AquaticAlchemistTriggeredAbility copy() {
        return new AquaticAlchemistTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return this.isFirstInstantOrSorceryCastByPlayerOnTurn(spell, game);
    }

    private boolean isFirstInstantOrSorceryCastByPlayerOnTurn(Spell spell, Game game) {
        SpellsCastWatcher watcher;
        if (spell != null && (watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)) != null) {
            List eligibleSpells = watcher.getSpellsCastThisTurn(this.getControllerId()).stream().filter(spell1 -> spell1.isInstantOrSorcery(game)).collect(Collectors.toList());
            return eligibleSpells.size() == 1 && ((Spell)eligibleSpells.get(0)).getId().equals(spell.getId());
        }
        return false;
    }
}

