/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;

class AragornCompanyLeaderTriggeredAbility
extends TriggeredAbilityImpl {
    AragornCompanyLeaderTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.addTarget((Target)new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_ANOTHER_TARGET_CREATURE));
    }

    private AragornCompanyLeaderTriggeredAbility(AragornCompanyLeaderTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AragornCompanyLeaderTriggeredAbility copy() {
        return new AragornCompanyLeaderTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId()) || !event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        CounterType counterType = CounterType.findByName((String)event.getData());
        if (counterType == null) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new AddCountersTargetEffect(counterType.createInstance()));
        return true;
    }

    public String getRule() {
        return "Whenever you put one or more counters on {this}, put one of each of those kinds of counters on up to one other target creature.";
    }
}

