/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ArashinSovereignEffect
extends OneShotEffect {
    public ArashinSovereignEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put it on the top or bottom of its owner's library";
    }

    private ArashinSovereignEffect(ArashinSovereignEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArashinSovereignEffect copy() {
        return new ArashinSovereignEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card sourceCard = game.getCard(source.getSourceId());
        if (controller != null && sourceCard != null) {
            if (game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD) {
                boolean onTop = controller.chooseUse(this.outcome, "Put " + sourceCard.getName() + " on top of it's owners library (otherwise on bottom)?", source, game);
                controller.moveCardToLibraryWithInfo(sourceCard, source, game, Zone.GRAVEYARD, onTop, true);
            }
            return true;
        }
        return false;
    }
}

