/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.cards.a.CastSpellYourLastTurnWatcher;
import mage.cards.a.PermanentsEnteredBattlefieldYourLastTurnWatcher;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;

class ArboriaEffect
extends RestrictionEffect {
    ArboriaEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures can't attack a player unless that player cast a spell or put a nontoken permanent onto the battlefield during their last turn";
    }

    private ArboriaEffect(ArboriaEffect effect) {
        super((RestrictionEffect)effect);
    }

    public ArboriaEffect copy() {
        return new ArboriaEffect(this);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null) {
            return true;
        }
        if (!game.getPlayers().containsKey((Object)defenderId)) {
            return true;
        }
        CastSpellYourLastTurnWatcher watcher = (CastSpellYourLastTurnWatcher)game.getState().getWatcher(CastSpellYourLastTurnWatcher.class);
        if (watcher != null && watcher.getAmountOfSpellsCastOnPlayersTurn(defenderId) > 0) {
            return true;
        }
        PermanentsEnteredBattlefieldYourLastTurnWatcher watcher2 = (PermanentsEnteredBattlefieldYourLastTurnWatcher)game.getState().getWatcher(PermanentsEnteredBattlefieldYourLastTurnWatcher.class);
        if (watcher2 != null && watcher2.getPermanentsEnteringOnPlayersLastTurn(game, defenderId) != null) {
            for (Permanent permanent : watcher2.getPermanentsEnteringOnPlayersLastTurn(game, defenderId)) {
                if (permanent == null || permanent instanceof PermanentToken) continue;
                return true;
            }
        }
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return true;
    }
}

