/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.ApprovingObject;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ArcaneBombardmentEffect
extends OneShotEffect {
    ArcaneBombardmentEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "exile an instant or sorcery card at random from your graveyard. Then copy each card exiled with {this}. You may cast any number of the copies without paying their mana costs.";
    }

    private ArcaneBombardmentEffect(ArcaneBombardmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArcaneBombardmentEffect copy() {
        return new ArcaneBombardmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cardsInGraveyard = new CardsImpl(player.getGraveyard().getCards((FilterCard)new FilterInstantOrSorceryCard(), game));
        if (cardsInGraveyard.isEmpty()) {
            return false;
        }
        Card cardToExile = cardsInGraveyard.getRandom(game);
        if (cardToExile == null) {
            return false;
        }
        player.moveCards(cardToExile, Zone.EXILED, source, game);
        MageObjectReference mor = new MageObjectReference((MageObject)cardToExile, game);
        ArrayList<MageObjectReference> exiledCards = (ArrayList<MageObjectReference>)game.getState().getValue(source.getSourceId() + "_exiledCards");
        if (exiledCards == null) {
            exiledCards = new ArrayList<MageObjectReference>();
            game.getState().setValue(source.getSourceId() + "_exiledCards", exiledCards);
        }
        exiledCards.add(mor);
        CardsImpl copies = new CardsImpl();
        for (MageObjectReference reference : exiledCards) {
            Card card = reference.getCard(game);
            if (card == null) continue;
            Card copiedCard = game.copyCard(card, source, source.getControllerId());
            copies.add(copiedCard);
        }
        if (!copies.isEmpty()) {
            TargetCard target = new TargetCard(0, copies.size(), Zone.EXILED, new FilterCard("copies to cast (in order they're chosen)"));
            player.choose(Outcome.PlayForFree, (Cards)copies, target, source, game);
            List targets = target.getTargets();
            for (UUID targetId : targets) {
                Card copiedCard = game.getCard(targetId);
                if (copiedCard == null || copiedCard.getSpellAbility() == null) continue;
                game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
                player.cast(player.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
            }
        }
        return true;
    }
}

