/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ArcaneEndeavorEffect
extends OneShotEffect {
    ArcaneEndeavorEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll two d8 and choose one result. Draw cards equal to that result. Then you may cast an instant or sorcery spell with mana value less than or equal to the other result from your hand without paying its mana cost";
    }

    private ArcaneEndeavorEffect(ArcaneEndeavorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArcaneEndeavorEffect copy() {
        return new ArcaneEndeavorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int second;
        int first;
        int secondResult;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List results = player.rollDice(this.outcome, source, game, 8, 2, 0);
        int firstResult = (Integer)results.get(0);
        if (firstResult != (secondResult = ((Integer)results.get(1)).intValue()) && player.chooseUse(this.outcome, "Choose a number of cards to draw", "The other number will be the maximum mana value of the spell you cast", "" + firstResult, "" + secondResult, source, game)) {
            first = firstResult;
            second = secondResult;
        } else {
            first = secondResult;
            second = firstResult;
        }
        player.drawCards(first, source, game);
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, second + 1));
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)player.getHand()), (FilterCard)filter);
        return true;
    }
}

