/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ArcbondEffect
extends OneShotEffect {
    ArcbondEffect() {
        super(Outcome.Benefit);
    }

    private ArcbondEffect(ArcbondEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArcbondEffect copy() {
        return new ArcbondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int damage = (Integer)this.getValue("damage");
        UUID sourceId = (UUID)this.getValue("sourceId");
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && damage > 0 && sourceId != null) {
            Permanent targetObject = game.getPermanentOrLKIBattlefield(sourceId);
            if (targetObject != null) {
                game.informPlayers(sourceObject.getLogName() + ": " + targetObject.getLogName() + " deals " + damage + " damage to each other creature and each player");
            }
            FilterCreaturePermanent filter = new FilterCreaturePermanent("each other creature");
            filter.add(Predicates.not((Predicate)new PermanentIdPredicate(sourceId)));
            return new DamageEverythingEffect((DynamicValue)StaticValue.get((int)damage), (FilterPermanent)filter, sourceId).apply(game, source);
        }
        return false;
    }
}

