/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ArchangelOfStrifeChooseEffect
extends OneShotEffect {
    ArchangelOfStrifeChooseEffect() {
        super(Outcome.Neutral);
        this.staticText = "each player chooses war or peace.";
    }

    private ArchangelOfStrifeChooseEffect(ArchangelOfStrifeChooseEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            sourcePermanent = game.getPermanentEntering(source.getSourceId());
        }
        if (controller != null && sourcePermanent != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                ChoiceImpl choice = new ChoiceImpl(true);
                choice.setMessage("Select war or peace");
                choice.getChoices().add("war");
                choice.getChoices().add("peace");
                if (!player.choose(Outcome.Neutral, (Choice)choice, game)) continue;
                if (!game.isSimulation()) {
                    game.informPlayers(sourcePermanent.getLogName() + ": " + player.getLogName() + " has chosen " + choice.getChoice());
                }
                game.getState().setValue(playerId + "_" + source.getSourceId() + "_modeChoice", (Object)choice.getChoice());
                sourcePermanent.addInfo("_" + playerId + "_modeChoice", "<font color = 'blue'>" + player.getName() + " chose: " + choice.getChoice() + "</font>", game);
            }
            return true;
        }
        return false;
    }

    public ArchangelOfStrifeChooseEffect copy() {
        return new ArchangelOfStrifeChooseEffect(this);
    }
}

