/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ArchelosLagoonMysticEffect
extends ReplacementEffectImpl {
    private final boolean tapped;

    ArchelosLagoonMysticEffect(boolean tapped) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.tapped = tapped;
        this.staticText = "as long as {this} is " + (tapped ? "" : "un") + "tapped, other permanents enter " + (tapped ? "" : "un") + "tapped";
    }

    private ArchelosLagoonMysticEffect(ArchelosLagoonMysticEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.tapped = effect.tapped;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent target = ((EntersTheBattlefieldEvent)event).getTarget();
        if (target != null) {
            target.setTapped(this.tapped);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        Permanent targetObject = ((EntersTheBattlefieldEvent)event).getTarget();
        if (targetObject == null) {
            return false;
        }
        return !sourceObject.getId().equals(targetObject.getId()) && sourceObject.isTapped() == this.tapped;
    }

    public ArchelosLagoonMysticEffect copy() {
        return new ArchelosLagoonMysticEffect(this);
    }
}

