/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ArdenAngelEffect
extends OneShotEffect {
    ArdenAngelEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a four-sided die. If the result is 1, return this card from your graveyard to the battlefield";
    }

    private ArdenAngelEffect(ArdenAngelEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArdenAngelEffect copy() {
        return new ArdenAngelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.rollDice(this.outcome, source, game, 4) != 1) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

