/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class AridArchwayEffect
extends OneShotEffect {
    AridArchwayEffect() {
        super(Outcome.Benefit);
        this.staticText = "return a land you control to its owner's hand. If another Desert was returned this way, surveil 1";
    }

    private AridArchwayEffect(AridArchwayEffect effect) {
        super((OneShotEffect)effect);
    }

    public AridArchwayEffect copy() {
        return new AridArchwayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source, game, 1)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        boolean flag = permanent.hasSubtype(SubType.DESERT, game) && !new MageObjectReference((MageObject)permanent, game).refersTo(source, game);
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (flag) {
            player.surveil(1, source, game);
        }
        return true;
    }
}

