/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class ArmoredKincallerEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a Dinosaur card");
    private static final FilterPermanent filter2 = new FilterPermanent(SubType.DINOSAUR, "");

    ArmoredKincallerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may reveal a Dinosaur card from your hand. If you do or if you control another Dinosaur, you gain 3 life";
    }

    private ArmoredKincallerEffect(ArmoredKincallerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArmoredKincallerEffect copy() {
        return new ArmoredKincallerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, filter);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.revealCards(source, (Cards)new CardsImpl(card), game);
        }
        if (card != null || game.getBattlefield().contains(filter2, source, game, 1)) {
            player.gainLife(3, game, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.DINOSAUR.getPredicate());
        filter2.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

