/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ArmoryAutomatonEffect
extends OneShotEffect {
    ArmoryAutomatonEffect() {
        super(Outcome.Benefit);
        this.staticText = "attach any number of target Equipment to it";
    }

    private ArmoryAutomatonEffect(ArmoryAutomatonEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArmoryAutomatonEffect copy() {
        return new ArmoryAutomatonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = source.getSourcePermanentIfItStillExists(game);
        if (creature == null) {
            return false;
        }
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent equipment = game.getPermanent(targetId);
            if (equipment == null) continue;
            creature.addAttachment(equipment.getId(), source, game);
        }
        return true;
    }
}

