/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class ArtificerClassWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    ArtificerClassWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.isArtifact(game)) {
            this.playerSet.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    public static boolean checkPlayer(UUID playerId, Game game) {
        return ((ArtificerClassWatcher)game.getState().getWatcher(ArtificerClassWatcher.class)).playerSet.contains(playerId);
    }
}

