/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class ArtistsTalentEffect
extends ReplacementEffectImpl {
    ArtistsTalentEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a source you control would deal noncombat damage to an opponent or a permanent an opponent controls, it deals that much damage plus 2 instead";
    }

    private ArtistsTalentEffect(ArtistsTalentEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ArtistsTalentEffect copy() {
        return new ArtistsTalentEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (((DamageEvent)event).isCombatDamage() || !source.isControlledBy(game.getControllerId(event.getSourceId()))) {
            return false;
        }
        Set opponents = game.getOpponents(source.getControllerId());
        return opponents.contains(event.getTargetId()) || opponents.contains(game.getControllerId(event.getTargetId()));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)2));
        return false;
    }
}

