/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.target.targetpointer.FixedTarget;

class ArvinoxTheMindFlailSpendAnyManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    public ArvinoxTheMindFlailSpendAnyManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.Custom, Outcome.Benefit);
        this.staticText = "you may spend mana as though it were mana of any color to cast it";
    }

    private ArvinoxTheMindFlailSpendAnyManaEffect(ArvinoxTheMindFlailSpendAnyManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ArvinoxTheMindFlailSpendAnyManaEffect copy() {
        return new ArvinoxTheMindFlailSpendAnyManaEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card theCard = game.getCard(objectId);
        if (theCard == null) {
            return false;
        }
        objectId = theCard.getMainCard().getId();
        if (objectId.equals(((FixedTarget)this.getTargetPointer()).getTarget()) && game.getState().getZoneChangeCounter(objectId) <= ((FixedTarget)this.getTargetPointer()).getZoneChangeCounter() + 1) {
            return source.isControlledBy(affectedControllerId);
        }
        if (((FixedTarget)this.getTargetPointer()).getTarget().equals(objectId)) {
            this.discard();
        }
        return false;
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

