/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;

public final class ArwensGift
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent("you control two or more legendary creatures");
    private static final Condition condition;
    private static final Hint hint;

    public ArwensGift(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{3}{U}");
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(1, condition)).setRuleAtTheTop(true).addHint(hint));
        this.getSpellAbility().addEffect((Effect)new ScryEffect(2, false));
        this.getSpellAbility().addEffect((Effect)new DrawCardSourceControllerEffect(2).concatBy(", then"));
    }

    private ArwensGift(ArwensGift card) {
        super((CardImpl)card);
    }

    public ArwensGift copy() {
        return new ArwensGift(this);
    }

    static {
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
        condition = new PermanentsOnTheBattlefieldCondition(filter, ComparisonType.MORE_THAN, 1);
        hint = new ConditionHint(condition, "You control two or more legendary creatures");
    }
}

