/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.a.AscentOfTheWorthyRedirectEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class AscentOfTheWorthyEffect
extends OneShotEffect {
    AscentOfTheWorthyEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature you control. Until your next turn, all damage that would be dealt to creatures you control is dealt to that creature instead";
    }

    private AscentOfTheWorthyEffect(AscentOfTheWorthyEffect effect) {
        super((OneShotEffect)effect);
    }

    public AscentOfTheWorthyEffect copy() {
        return new AscentOfTheWorthyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.informPlayers(player.getName() + " chooses to have all damage redirected to " + permanent.getIdName());
        game.addEffect((ContinuousEffect)new AscentOfTheWorthyRedirectEffect(new MageObjectReference((MageObject)permanent, game)), source);
        return false;
    }
}

