/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AscentOfTheWorthyRedirectEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;

    AscentOfTheWorthyRedirectEffect(MageObjectReference mor) {
        super(Duration.UntilYourNextTurn, Outcome.RedirectDamage);
        this.mor = mor;
    }

    private AscentOfTheWorthyRedirectEffect(AscentOfTheWorthyRedirectEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        Permanent permanent = this.mor.getPermanent(game);
        if (permanent != null) {
            permanent.damage(damageEvent.getAmount(), event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), damageEvent.getAppliedEffects());
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId());
    }

    public AscentOfTheWorthyRedirectEffect copy() {
        return new AscentOfTheWorthyRedirectEffect(this);
    }
}

