/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class AscentOfTheWorthyReturnEffect
extends OneShotEffect {
    AscentOfTheWorthyReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature card from your graveyard to the battlefield with a flying counter on it. That creature is an Angel Warrior in addition to its other types";
    }

    private AscentOfTheWorthyReturnEffect(AscentOfTheWorthyReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public AscentOfTheWorthyReturnEffect copy() {
        return new AscentOfTheWorthyReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        Counters countersToAdd = new Counters(new Counter[0]);
        countersToAdd.addCounter(CounterType.FLYING.createInstance());
        game.setEnterWithCounters(card.getId(), countersToAdd);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        game.addEffect(new AddCardSubTypeTargetEffect(SubType.ANGEL, Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addEffect(new AddCardSubTypeTargetEffect(SubType.WARRIOR, Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

