/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class AshcoatEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard("Rat creature cards");

    AshcoatEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "If you do, return up to two Rat creature cards from your graveyard to your hand.";
    }

    private AshcoatEffect(AshcoatEffect effect) {
        super((OneShotEffect)effect);
    }

    public AshcoatEffect copy() {
        return new AshcoatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 2, (FilterCard)filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
        return true;
    }

    static {
        filter.add((Predicate)SubType.RAT.getPredicate());
    }
}

