/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class AshesOfTheFallenEffect
extends ContinuousEffectImpl {
    AshesOfTheFallenEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Each creature card in your graveyard has the chosen creature type in addition to its other types";
    }

    private AshesOfTheFallenEffect(AshesOfTheFallenEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)permanent.getId(), (Game)game);
            if (subType != null) {
                for (UUID cardId : controller.getGraveyard()) {
                    MageObject mageObject;
                    Card card = game.getCard(cardId);
                    if (card == null || !card.isCreature(game) || card.hasSubtype(subType, game) || (mageObject = game.getObject(card.getId())) == null) continue;
                    CardUtil.getObjectPartsAsObjects((MageObject)mageObject).forEach(objectPart -> {
                        if (objectPart.isCreature(game)) {
                            game.getState().getCreateMageObjectAttribute(objectPart, game).getSubtype().add((Object)subType);
                        }
                    });
                }
            } else {
                this.discard();
            }
            return true;
        }
        return false;
    }

    public AshesOfTheFallenEffect copy() {
        return new AshesOfTheFallenEffect(this);
    }
}

