/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class AshiokNightmareMuseCastEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("face-up cards your opponents own from exile");

    AshiokNightmareMuseCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may cast up to three spells from among face-up cards your opponents own from exile without paying their mana costs.";
    }

    private AshiokNightmareMuseCastEffect(AshiokNightmareMuseCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public AshiokNightmareMuseCastEffect copy() {
        return new AshiokNightmareMuseCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl(game.getExile().getCardsInRange(filter, controller.getId(), source, game)), (FilterCard)StaticFilters.FILTER_CARD, (int)3);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getOwnerPredicate());
        filter.add(Predicates.not((Predicate)FaceDownPredicate.instance));
    }
}

