/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class AshiokNightmareWeaverPutIntoPlayEffect
extends OneShotEffect {
    AshiokNightmareWeaverPutIntoPlayEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put a creature card with mana value X exiled with {this} onto the battlefield under your control. That creature is a Nightmare in addition to its other types";
    }

    private AshiokNightmareWeaverPutIntoPlayEffect(AshiokNightmareWeaverPutIntoPlayEffect effect) {
        super((OneShotEffect)effect);
    }

    public AshiokNightmareWeaverPutIntoPlayEffect copy() {
        return new AshiokNightmareWeaverPutIntoPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int cmc = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + cmc);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, cmc));
        TargetCardInExile target = new TargetCardInExile((FilterCard)filter, CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (!target.canChoose(controller.getId(), source, game)) {
            return false;
        }
        controller.chooseTarget(Outcome.PutCreatureInPlay, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            game.addEffect(new AddCardSubTypeTargetEffect(SubType.NIGHTMARE, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

