/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class AshioksErasureExileEffect
extends OneShotEffect {
    AshioksErasureExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target spell";
    }

    private AshioksErasureExileEffect(AshioksErasureExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public AshioksErasureExileEffect copy() {
        return new AshioksErasureExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (controller == null || sourceObject == null || spell == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        return controller.moveCardsToExile((Card)spell, source, game, true, exileId, sourceObject.getIdName());
    }
}

