/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class AshioksErasureReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    AshioksErasureReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Your opponents can't cast spells with the same name as the exiled card";
    }

    private AshioksErasureReplacementEffect(AshioksErasureReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent((GameEvent)event, (Game)game);
        if (spellAbility == null) {
            return false;
        }
        Card card = spellAbility.getCharacteristics(game);
        if (sourcePermanent == null || card == null) {
            return false;
        }
        UUID exileZone = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        ExileZone exile = game.getExile().getExileZone(exileZone);
        if (exile == null) {
            exileZone = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            exile = game.getExile().getExileZone(exileZone);
        }
        if (exile == null) {
            return false;
        }
        Set cards = exile.getCards(game);
        if (cards.isEmpty()) {
            return false;
        }
        Card exiledCard = (Card)cards.iterator().next();
        if (exiledCard != null) {
            return CardUtil.haveSameNames((MageObject)exiledCard, (MageObject)card);
        }
        return false;
    }

    public AshioksErasureReplacementEffect copy() {
        return new AshioksErasureReplacementEffect(this);
    }
}

