/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.SacrificeCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AshnodTheUncaringTriggeredAbility
extends TriggeredAbilityImpl {
    AshnodTheUncaringTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CopyStackObjectEffect(), true);
        this.setTriggerPhrase("Whenever you activate an ability of an artifact or creature that isn't a mana ability, if one or more permanents were sacrificed to activate it, ");
    }

    private AshnodTheUncaringTriggeredAbility(AshnodTheUncaringTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AshnodTheUncaringTriggeredAbility copy() {
        return new AshnodTheUncaringTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackAbility stackAbility;
        block6: {
            block5: {
                if (!this.isControlledBy(event.getPlayerId())) {
                    return false;
                }
                stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
                if (stackAbility == null || stackAbility.getStackAbility().isManaActivatedAbility()) break block5;
                if (!stackAbility.getStackAbility().getCosts().stream().noneMatch(SacrificeCost.class::isInstance)) break block6;
            }
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(stackAbility.getSourceId());
        if (permanent == null || !permanent.isArtifact(game) && !permanent.isCreature(game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }
}

