/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class AshnodsCylixEffect
extends OneShotEffect {
    AshnodsCylixEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player looks at the top three cards of their library, puts one of them back on top of their library, then exiles the rest";
    }

    private AshnodsCylixEffect(AshnodsCylixEffect effect) {
        super((OneShotEffect)effect);
    }

    public AshnodsCylixEffect copy() {
        return new AshnodsCylixEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        player.lookAtCards(source, null, (Cards)cards, game);
        TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put on top of your library"));
        if (player.choose(Outcome.Benefit, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
            cards.remove(card);
            game.informPlayers(source.getSourceObject(game).getIdName() + ": " + player.getLogName() + " puts a card back on top of their library");
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        return true;
    }
}

