/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class AshnodsInterventionAbility
extends TriggeredAbilityImpl {
    public AshnodsInterventionAbility() {
        super(Zone.ALL, (Effect)new ReturnToHandSourceEffect());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private AshnodsInterventionAbility(AshnodsInterventionAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AshnodsInterventionAbility copy() {
        return new AshnodsInterventionAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getTargetId().equals(this.sourceId) && zEvent.getFromZone() == Zone.BATTLEFIELD && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.EXILED);
    }

    public String getRule() {
        return "When {this} dies or is put into exile from the battlefield, return it to its owner's hand";
    }
}

