/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AssaultSuitGainControlEffect
extends OneShotEffect {
    AssaultSuitGainControlEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may have that player gain control of equipped creature until end of turn. If you do, untap it";
    }

    public AssaultSuitGainControlEffect(AssaultSuitGainControlEffect effect) {
        super((OneShotEffect)effect);
    }

    public AssaultSuitGainControlEffect copy() {
        return new AssaultSuitGainControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        Permanent equipment = source.getSourcePermanentIfItStillExists(game);
        if (controller == null || activePlayer == null || equipment == null) {
            return false;
        }
        if (equipment.getAttachedTo() == null) {
            return true;
        }
        Permanent equippedCreature = game.getPermanent(equipment.getAttachedTo());
        if (equippedCreature == null || !controller.chooseUse(this.outcome, "Have " + activePlayer.getLogName() + " gain control of " + equippedCreature.getLogName() + '?', source, game)) {
            return true;
        }
        equippedCreature.untap(game);
        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfTurn, activePlayer.getId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(equipment.getAttachedTo(), game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

