/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AssaultronDominatorEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>(Arrays.asList("+1/+1", "First strike", "Trample"));

    AssaultronDominatorEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put your choice of a +1/+1, first strike, or trample counter on that creature";
    }

    protected AssaultronDominatorEffect(AssaultronDominatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        CounterType counterType;
        String chosen;
        Player player = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || creature == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose +1/+1, first strike, or trample counter");
        choice.setChoices(choices);
        player.choose(this.outcome, (Choice)choice, game);
        switch (chosen = choice.getChoice()) {
            case "+1/+1": {
                counterType = CounterType.P1P1;
                break;
            }
            case "First strike": {
                counterType = CounterType.FIRST_STRIKE;
                break;
            }
            case "Trample": {
                counterType = CounterType.TRAMPLE;
                break;
            }
            default: {
                return false;
            }
        }
        return creature.addCounters(counterType.createInstance(), source, game);
    }

    public AssaultronDominatorEffect copy() {
        return new AssaultronDominatorEffect(this);
    }
}

