/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class AstarionsThirstEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("commander creature you control");

    AstarionsThirstEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature. Put X +1/+1 counters on a commander creature you control, where X is the power of the creature exiled this way";
    }

    private AstarionsThirstEffect(AstarionsThirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public AstarionsThirstEffect copy() {
        return new AstarionsThirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent commander;
        Player player = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || creature == null) {
            return false;
        }
        player.moveCards((Card)creature, Zone.EXILED, source, game);
        if (creature.getPower().getValue() < 1) {
            return true;
        }
        List commanders = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        switch (commanders.size()) {
            case 0: {
                return true;
            }
            case 1: {
                commander = (Permanent)commanders.get(0);
                break;
            }
            default: {
                TargetPermanent target = new TargetPermanent(filter);
                target.withNotTarget(true);
                player.choose(this.outcome, (Target)target, source, game);
                commander = game.getPermanent(target.getFirstTarget());
            }
        }
        if (commander != null) {
            commander.addCounters(CounterType.P1P1.createInstance(creature.getPower().getValue()), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)CommanderPredicate.instance);
    }
}

