/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.ManaType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AstralCornucopiaManaEffect
extends ManaEffect {
    AstralCornucopiaManaEffect() {
        this.staticText = "Choose a color. Add one mana of that color for each charge counter on {this}";
    }

    private AstralCornucopiaManaEffect(AstralCornucopiaManaEffect effect) {
        super((ManaEffect)effect);
    }

    public AstralCornucopiaManaEffect copy() {
        return new AstralCornucopiaManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return netMana;
        }
        int counters = sourcePermanent.getCounters(game).getCount(CounterType.CHARGE);
        if (counters > 0) {
            netMana.add(Mana.WhiteMana((int)counters));
            netMana.add(Mana.BlueMana((int)counters));
            netMana.add(Mana.BlackMana((int)counters));
            netMana.add(Mana.GreenMana((int)counters));
            netMana.add(Mana.RedMana((int)counters));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return null;
        }
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (sourcePermanent == null || controller == null) {
            return null;
        }
        int counters = sourcePermanent.getCounters(game).getCount(CounterType.CHARGE);
        if (counters == 0) {
            return null;
        }
        ChoiceColor choice = new ChoiceColor();
        choice.setMessage("Choose a color to add mana of that color");
        if (!controller.choose(this.outcome, (Choice)choice, game)) {
            return null;
        }
        ManaType chosenType = ManaType.findByName((String)choice.getChoice());
        return chosenType == null ? null : new Mana(chosenType, counters);
    }
}

