/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.a.AstralDriftEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class AstralDriftTriggeredAbility
extends TriggeredAbilityImpl {
    AstralDriftTriggeredAbility() {
        super(Zone.ALL, (Effect)new AstralDriftEffect(), true);
        this.addTarget((Target)new TargetCreaturePermanent());
    }

    private AstralDriftTriggeredAbility(AstralDriftTriggeredAbility effect) {
        super((TriggeredAbilityImpl)effect);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject item = game.getState().getStack().getFirstOrNull();
        if (!(item instanceof StackAbility) || !(item.getStackAbility() instanceof CyclingAbility)) {
            return false;
        }
        if (event.getSourceId().equals(this.getSourceId())) {
            return true;
        }
        return game.getPermanent(this.getSourceId()) != null && event.getPlayerId().equals(this.controllerId);
    }

    public AstralDriftTriggeredAbility copy() {
        return new AstralDriftTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you cycle {this} or cycle another card while {this} is on the battlefield, you may exile target creature. If you do, return that card to the battlefield under its owner's control at the beginning of the next end step.";
    }
}

