/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class AthreosDiesCreatureTriggeredAbility
extends TriggeredAbilityImpl {
    protected FilterCreaturePermanent filter;

    AthreosDiesCreatureTriggeredAbility(Effect effect, boolean optional, FilterCreaturePermanent filter) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.filter = filter;
        this.setTriggerPhrase("Whenever " + filter.getMessage() + " dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private AthreosDiesCreatureTriggeredAbility(AthreosDiesCreatureTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.filter = ability.filter;
    }

    public AthreosDiesCreatureTriggeredAbility copy() {
        return new AthreosDiesCreatureTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent()) {
            return false;
        }
        if (zEvent.getTarget() == null || !this.filter.match(zEvent.getTarget(), this.controllerId, (Ability)this, game)) {
            return false;
        }
        for (Effect effect : this.getEffects()) {
            effect.setValue("creatureId", (Object)event.getTargetId());
        }
        return true;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

