/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AudaciousReshapersEffect
extends OneShotEffect {
    AudaciousReshapersEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal an artifact card. Put that card onto the battlefield and the rest on the bottom of your library in a random order. {this} deals damage to you equal to the number of cards revealed this way";
    }

    private AudaciousReshapersEffect(AudaciousReshapersEffect effect) {
        super((OneShotEffect)effect);
    }

    public AudaciousReshapersEffect copy() {
        return new AudaciousReshapersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card artifact = null;
        for (Card card : player.getLibrary().getCards(game)) {
            if (card == null) continue;
            cards.add(card);
            if (!card.isArtifact(game)) continue;
            artifact = card;
            break;
        }
        int size = cards.size();
        player.revealCards(source, (Cards)cards, game);
        if (artifact != null) {
            player.moveCards(artifact, Zone.BATTLEFIELD, source, game);
        }
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.LIBRARY);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        player.damage(size, source.getSourceId(), source, game);
        return true;
    }
}

