/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class AudaciousSwapEffect
extends OneShotEffect {
    AudaciousSwapEffect() {
        super(Outcome.Benefit);
        this.staticText = "the owner of target nonenchantment permanent shuffles it into their library, then exiles the top card of their library. If it's a land card, they put it onto the battlefield. Otherwise, they may cast it without paying its mana cost";
    }

    private AudaciousSwapEffect(AudaciousSwapEffect effect) {
        super((OneShotEffect)effect);
    }

    public AudaciousSwapEffect copy() {
        return new AudaciousSwapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getOwnerId());
        if (player == null) {
            return false;
        }
        player.putCardsOnTopOfLibrary((Card)permanent, game, source, false);
        player.shuffleLibrary(source, game);
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return true;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (!card.isLand(game)) {
            CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card);
            return true;
        }
        if (player.chooseUse(Outcome.PutLandInPlay, "Put " + card.getName() + " onto the battlefield?", source, game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

