/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.a.AureliasFuryCantCastEffect;
import mage.cards.a.AureliasFuryDamagedByWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AureliasFuryEffect
extends OneShotEffect {
    AureliasFuryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Tap each creature dealt damage this way. Players dealt damage this way can't cast noncreature spells this turn";
    }

    private AureliasFuryEffect(AureliasFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public AureliasFuryEffect copy() {
        return new AureliasFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        AureliasFuryDamagedByWatcher watcher = (AureliasFuryDamagedByWatcher)game.getState().getWatcher(AureliasFuryDamagedByWatcher.class, source.getSourceId());
        if (watcher != null) {
            for (UUID creatureId : watcher.getDamagedCreatures()) {
                Permanent permanent = game.getPermanent(creatureId);
                if (permanent == null) continue;
                permanent.tap(source, game);
            }
            for (UUID playerId : watcher.getDamagedPlayers()) {
                AureliasFuryCantCastEffect effect = new AureliasFuryCantCastEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(playerId));
                game.addEffect((ContinuousEffect)effect, source);
            }
            watcher.reset();
        }
        return false;
    }
}

