/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.a.AuroraShifterCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

class AuroraShifterCopyEffect
extends OneShotEffect {
    AuroraShifterCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of another target creature you control, except it has this ability and \"Whenever this creature deals combat damage to a player, you get that many {E}.\"";
    }

    private AuroraShifterCopyEffect(AuroraShifterCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public AuroraShifterCopyEffect copy() {
        return new AuroraShifterCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && copyFromPermanent != null) {
            game.copyPermanent(Duration.WhileOnBattlefield, copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new AuroraShifterCopyApplier());
            return true;
        }
        return false;
    }
}

