/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SourceMutatedCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AuspiciousStarrixEffect
extends OneShotEffect {
    AuspiciousStarrixEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile X permanent cards, where X is the number of times this creature has mutated. Put those permanent cards onto the battlefield.";
    }

    private AuspiciousStarrixEffect(AuspiciousStarrixEffect effect) {
        super((OneShotEffect)effect);
    }

    public AuspiciousStarrixEffect copy() {
        return new AuspiciousStarrixEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = SourceMutatedCount.instance.calculate(game, source, (Effect)this);
        int count = 0;
        CardsImpl toExile = new CardsImpl();
        CardsImpl toBattlefield = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            if (card != null && card.isPermanent(game)) {
                toBattlefield.add(card);
                ++count;
            }
            toExile.add(card);
            if (count < xValue) continue;
            break;
        }
        player.moveCards((Cards)toExile, Zone.EXILED, source, game);
        return player.moveCards((Cards)toBattlefield, Zone.BATTLEFIELD, source, game);
    }
}

