/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class AvatarOfGrowthSearchEffect
extends OneShotEffect {
    AvatarOfGrowthSearchEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player searches their library for up to two basic land cards, puts them onto the battlefield, then shuffles";
    }

    private AvatarOfGrowthSearchEffect(AvatarOfGrowthSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public AvatarOfGrowthSearchEffect copy() {
        return new AvatarOfGrowthSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashSet toBattlefield = new HashSet();
        if (controller != null) {
            Player player;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetCardInLibrary target;
                player = game.getPlayer(playerId);
                if (player == null || !player.searchLibrary(target = new TargetCardInLibrary(0, 2, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), source, game) || target.getTargets().isEmpty()) continue;
                toBattlefield.addAll(new CardsImpl((Collection)target.getTargets()).getCards(game));
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

