/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;

class AwakenTheErstwhileEffect
extends OneShotEffect {
    AwakenTheErstwhileEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player discards all the cards in their hand, then creates that many 2/2 black Zombie creature tokens";
    }

    private AwakenTheErstwhileEffect(AwakenTheErstwhileEffect effect) {
        super((OneShotEffect)effect);
    }

    public AwakenTheErstwhileEffect copy() {
        return new AwakenTheErstwhileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashMap<UUID, Integer> cardsAmount = new HashMap<UUID, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                int cardsInHand;
                Player player = game.getPlayer(playerId);
                if (player == null || (cardsInHand = player.getHand().size()) <= 0) continue;
                player.discard(cardsInHand, false, false, source, game);
                cardsAmount.put(playerId, cardsInHand);
            }
            cardsAmount.entrySet().forEach(discardedHand -> {
                Player player = game.getPlayer((UUID)discardedHand.getKey());
                int tokensCount = (Integer)discardedHand.getValue();
                if (player != null && tokensCount > 0) {
                    new ZombieToken().putOntoBattlefield(tokensCount, game, source, player.getId());
                }
            });
            return true;
        }
        return false;
    }
}

