/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AwakenedAwarenessEffect
extends ContinuousEffectImpl {
    AwakenedAwarenessEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.SetPT_7b, Outcome.UnboostCreature);
        this.staticText = "As long as enchanted permanent is a creature, it has base power and toughness 1/1";
    }

    private AwakenedAwarenessEffect(AwakenedAwarenessEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AwakenedAwarenessEffect copy() {
        return new AwakenedAwarenessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = source.getSourcePermanentIfItStillExists(game);
        if (enchantment == null) {
            return false;
        }
        Permanent creature = game.getPermanent(enchantment.getAttachedTo());
        if (creature == null || !creature.isCreature(game)) {
            return false;
        }
        creature.getPower().setModifiedBaseValue(1);
        creature.getToughness().setModifiedBaseValue(1);
        return true;
    }
}

